/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.basic;

import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oauth.signpost.OAuth;
import oauth.signpost.OAuthConsumer;
import oauth.signpost.OAuthProvider;
import oauth.signpost.Parameter;
import oauth.signpost.basic.HttpRequestAdapter;
import oauth.signpost.exception.OAuthCommunicationException;
import oauth.signpost.exception.OAuthExpectationFailedException;
import oauth.signpost.exception.OAuthMessageSignerException;
import oauth.signpost.exception.OAuthNotAuthorizedException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultOAuthProvider
implements OAuthProvider {
    private String requestTokenEndpointUrl;
    private String accessTokenEndpointUrl;
    private String authorizationWebsiteUrl;
    private OAuthConsumer consumer;
    private transient HttpURLConnection connection;
    private Map<String, String> responseParameters;
    private boolean isOAuth10a;

    public DefaultOAuthProvider(OAuthConsumer consumer, String requestTokenEndpointUrl, String accessTokenEndpointUrl, String authorizationWebsiteUrl) {
        this.consumer = consumer;
        this.requestTokenEndpointUrl = requestTokenEndpointUrl;
        this.accessTokenEndpointUrl = accessTokenEndpointUrl;
        this.authorizationWebsiteUrl = authorizationWebsiteUrl;
        this.responseParameters = new HashMap<String, String>();
    }

    @Override
    public String retrieveRequestToken(String callbackUrl) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException {
        this.consumer.setTokenWithSecret(null, null);
        this.retrieveToken(OAuth.addQueryParameters(this.requestTokenEndpointUrl, "oauth_callback", callbackUrl));
        String callbackConfirmed = this.responseParameters.get("oauth_callback_confirmed");
        this.responseParameters.remove("oauth_callback_confirmed");
        this.isOAuth10a = Boolean.TRUE.toString().equals(callbackConfirmed);
        if (this.isOAuth10a) {
            return OAuth.addQueryParameters(this.authorizationWebsiteUrl, "oauth_token", this.consumer.getToken());
        }
        return OAuth.addQueryParameters(this.authorizationWebsiteUrl, "oauth_token", this.consumer.getToken(), "oauth_callback", callbackUrl);
    }

    @Override
    public void retrieveAccessToken(String oauthVerifier) throws OAuthMessageSignerException, OAuthNotAuthorizedException, OAuthExpectationFailedException, OAuthCommunicationException {
        if (this.consumer.getToken() == null || this.consumer.getTokenSecret() == null) {
            throw new OAuthExpectationFailedException("Authorized request token or token secret not set. Did you retrieve an authorized request token before?");
        }
        this.retrieveToken(this.isOAuth10a && oauthVerifier != null ? OAuth.addQueryParameters(this.accessTokenEndpointUrl, "oauth_verifier", oauthVerifier) : this.accessTokenEndpointUrl);
    }

    private void retrieveToken(String endpointUrl) throws OAuthMessageSignerException, OAuthCommunicationException, OAuthNotAuthorizedException, OAuthExpectationFailedException {
        if (this.consumer.getConsumerKey() == null || this.consumer.getConsumerSecret() == null) {
            throw new OAuthExpectationFailedException("Consumer key or secret not set");
        }
        try {
            if (this.connection == null) {
                this.connection = (HttpURLConnection)new URL(endpointUrl).openConnection();
                this.connection.setRequestMethod("GET");
            }
            HttpRequestAdapter request = new HttpRequestAdapter(this.connection);
            this.consumer.sign(request);
            this.connection.connect();
            int statusCode = this.connection.getResponseCode();
            if (statusCode == 401) {
                throw new OAuthNotAuthorizedException();
            }
            List<Parameter> params = OAuth.decodeForm(this.connection.getInputStream());
            this.responseParameters = OAuth.toMap(params);
            String token = this.responseParameters.get("oauth_token");
            this.responseParameters.remove("oauth_token");
            String secret = this.responseParameters.get("oauth_token_secret");
            this.responseParameters.remove("oauth_token_secret");
            if (token == null || secret == null) {
                throw new OAuthExpectationFailedException("Request token or token secret not set in server reply. The service provider you use is probably buggy.");
            }
            this.consumer.setTokenWithSecret(token, secret);
        }
        catch (OAuthNotAuthorizedException e) {
            throw e;
        }
        catch (OAuthExpectationFailedException e) {
            throw e;
        }
        catch (Exception e) {
            throw new OAuthCommunicationException(e);
        }
        finally {
            if (this.connection != null) {
                this.connection.disconnect();
                this.connection = null;
            }
        }
    }

    @Override
    public Map<String, String> getResponseParameters() {
        return this.responseParameters;
    }

    void setHttpUrlConnection(HttpURLConnection connection) {
        this.connection = connection;
    }

    @Override
    public void setOAuth10a(boolean isOAuth10aProvider) {
        this.isOAuth10a = isOAuth10aProvider;
    }

    @Override
    public boolean isOAuth10a() {
        return this.isOAuth10a;
    }

    @Override
    public String getRequestTokenEndpointUrl() {
        return this.requestTokenEndpointUrl;
    }

    @Override
    public String getAccessTokenEndpointUrl() {
        return this.accessTokenEndpointUrl;
    }

    @Override
    public String getAuthorizationWebsiteUrl() {
        return this.authorizationWebsiteUrl;
    }

    @Override
    public OAuthConsumer getConsumer() {
        return this.consumer;
    }

    @Override
    public void setConsumer(OAuthConsumer consumer) {
        this.consumer = consumer;
    }
}

