/*
 * Decompiled with CFR 0.152.
 */
package oauth.signpost.commonshttp;

import java.io.IOException;
import java.io.InputStream;
import oauth.signpost.http.HttpRequest;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.client.methods.HttpUriRequest;

public class HttpRequestAdapter
implements HttpRequest {
    private HttpUriRequest request;
    private HttpEntity entity;

    public HttpRequestAdapter(HttpUriRequest request) {
        this.request = request;
        if (request instanceof HttpEntityEnclosingRequest) {
            this.entity = ((HttpEntityEnclosingRequest)request).getEntity();
        }
    }

    public String getHeader(String name) {
        Header header = this.request.getFirstHeader(name);
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public String getMethod() {
        return this.request.getRequestLine().getMethod();
    }

    public String getRequestUrl() {
        return this.request.getURI().toString();
    }

    public void setHeader(String name, String value) {
        this.request.setHeader(name, value);
    }

    public String getContentType() {
        if (this.entity == null) {
            return null;
        }
        Header header = this.entity.getContentType();
        if (header == null) {
            return null;
        }
        return header.getValue();
    }

    public InputStream getMessagePayload() throws IOException {
        if (this.entity == null) {
            return null;
        }
        return this.entity.getContent();
    }
}

